define([
    'underscore',
    'marionette',
    'App',
    'modules/appointments/appointments-module',
    'text!modules/appointments/requested/requested-appointment-status.html',
    'modules/page/popup/external-nav-behavior',
], function (
    _,
    Marionette,
    app,
    module,
    template,
    ExternalNavigation
) {
    'use strict';

    var EXPRESS_CARE_ID = module.clinicalServicesConstants.EXPRESS_CARE_ID;
    var COMMUNITY_CARE = 'CCPCPRVDR';
    var SUBMITTED_STATUS = 'Submitted';
    var CANCEL_CODE = 'DETCODE8';
    var SPECIALTY_NOT_AVALIABLE_CODE = 'DETCODE21';
    var CANCELLED_TEXT = 'You have successfully cancelled this request.';

    // eslint-disable-next-line
    var expressSubmittedTemplate = _.template('View status updates for this request under the "Requests" section of the Home page. Once scheduled, the resulting appointment will be available in the <a href="<%- link %>" class="external-link">VA Video Appointment</a> app.');

    // eslint-disable-next-line
    var CC_SUBMITTED_TEXT = 'View status updates for this request under the "Requests" section of the Appointments and Requests page.';

    // eslint-disable-next-line
    var DEFUALT_SUBMITTED = 'View status updates for this request under the "Requests" section of the Appointments and Requests page. Once scheduled, the resulting appointment will be displayed under the “Appointments” section of the same page.';

    return Marionette.View.extend({
        id: 'request-status-group',
        template: template,
        modelEvents: {'sync': 'render'},
        behaviors: {ExternalNavigation: {behaviorClass: ExternalNavigation}},
        templateContext: function () {
            var detailCode = this.model.get('appointmentRequestDetailCode');

            if (_.isEmpty(detailCode)) {
                detailCode = [{detailCode: {}}];
            }


            return {
                message: this.createStatusMessage(detailCode[0].detailCode),
                isLinkIncluded: this.isLinkIncluded(detailCode[0].detailCode),
            };
        },

        createStatusMessage: function(detailCode) {
            if (this.model.get('status') === SUBMITTED_STATUS) {
                return this._getSubmittedStatus(this.model.get('typeOfCareId'));
            } else if (!_.isEmpty(detailCode)) {
                return this._getDetailStatus(detailCode);
            }
            return '';
        },

        isLinkIncluded: function(detailCode) {
            if (_.isEmpty(detailCode)) {
                return false;
            }
            return detailCode.code === SPECIALTY_NOT_AVALIABLE_CODE;
        },

        _getSubmittedStatus: function(typeOfCareId) {
            if (typeOfCareId === EXPRESS_CARE_ID) {
                return expressSubmittedTemplate({link: app.resources.get('va-video-appointment-app').get('href')});
            } else if (typeOfCareId === COMMUNITY_CARE) {
                return CC_SUBMITTED_TEXT;
            }
            return DEFUALT_SUBMITTED;
        },

        _getDetailStatus: function(detailCode) {
            var id = detailCode.code;
            if (id === CANCEL_CODE) {
                return CANCELLED_TEXT;
            } else if (!_.isEmpty(detailCode)) {
                return _.escape(detailCode.veteranMessage) || '';
            }
            return '';
        },

    });
});
